(function ($) {
    "use strict";

    jQuery(document).ready(function () {
        jQuery('.fhpc_colorpick').each(function () {
            var $this = jQuery(this);
            jQuery(this).colpick({
                color: $this.val().substr(1, 7),
                onChange: function (hsb, hex, rgb, el, bySetColor) {
                    jQuery(el).val('#' + hex);
                }
            });
        });
        jQuery('.fhpc input[name="rolesAllowed"][value=""]').on('change', function () {
            if (jQuery(this).is(':checked')) {
                jQuery('input[name="rolesAllowed"]:not([value=""])').removeProp('checked');
            }
        });
        jQuery('.fhpc input[name="rolesAllowed"]:not([value=""])').on('change', function () {
            if (jQuery(this).is(':checked')) {
                jQuery('input[name="rolesAllowed"][value=""]').removeProp('checked');
            }
        });
        $('body').on('fhpc_itemSelected', function (e, element) {
            fhpc_itemSelected(element);
        });
        $('.fhpc [data-action="fhpc_chooseItemTarget"]').on('click', fhpc_chooseItemTarget);
        $('.fhpc [data-action="fhpc_chooseItemTarget"]').on('click', fhpc_chooseItemTarget);
        $('#fhpc_form_settings [data-action="fhpc_save"]').on('click', fhpc_saveSettings);
        $('#fhpc_form_item [data-action="fhpc_save"]').on('click', fhpc_saveItem);
        $('#fhpc_form_step [data-action="fhpc_save"]').on('click', fhpc_saveStep);

        jQuery('#fhpc_type').on('change', fhpc_checkType);
        fhpc_checkType();
        jQuery('#fhpc_actionNeeded').on('change', fhpc_checkAction);
        fhpc_checkAction();
        jQuery('#fhpc_overlaySelect').on('change', fhpc_checkOverlay);
        fhpc_checkOverlay();
        jQuery('#fhpc_stepID').on('change', fhpc_checkStep);
        fhpc_checkStep();
        jQuery('#fhpc_btnContinue').on('keyup', fhpc_checkBtns);
        jQuery('#fhpc_btnStop').on('keyup', fhpc_checkBtns);
        $('#fhpc_mobileEnabled').on('change', fhpc_mobileEnabledChanged);
        $('#fhpc_mobileEnabled').on('change', fhpc_mobileEnabledChanged);
        if ($('#fhpc_form_step').length > 0) {
            jQuery('#fhpc_onAdmin').on('change', fhpc_changeOnAdmin);
            jQuery('#fhpc_start').on('change', fhpc_checkStart);
            fhpc_checkStart();
        }

    });
    function fhpc_chooseItemTarget() {
        if (jQuery('#fhpc_selectDomPanel').length == 0) {
            if (jQuery('#fhpc_form_item input[name=page]').length > 0 && jQuery('#fhpc_form_item input[name=page]').val().length > 3) {
                if (jQuery('#fhpc_form_item input[name=page]').val().indexOf('http') < 0) {
                    fhpc_adminData.homeurl = fhpc_adminData.homeurl + jQuery('#fhpc_form_item input[name=page]').val();
                } else {
                    fhpc_adminData.homeurl = jQuery('#fhpc_form_item input[name=page]').val();
                }
            }
            if (jQuery('#onAdmin').val() == '1') {
                fhpc_adminData.homeurl = fhpc_adminData.adminurl;
            }
            fhpc_adminData.homeurl = fhpc_adminData.homeurl.replace('[ANY]', '');
            var $frame = jQuery('<iframe id="fhpc_selectDomFrame" src="' + fhpc_adminData.homeurl + '"></iframe>');
            jQuery('body').append($frame);
            var $panel = jQuery('<div id="fhpc_selectDomPanel"></div>');
            jQuery('body').append($panel);
            $panel.html(fhpc_adminData.txtLoading);
        } else {
            jQuery('#fhpc_selectDomPanel').html(fhpc_adminData.txtLoading);

        }
        fhpc_selectionPanelText();
    }
    var fhpc_modeSelection = false;

    function fhpc_activeItemSelectionMode() {
        $('#fhpc_selectDomFrame')[0].contentWindow.jQuery('body').trigger('fhpc_changeSelectionMode', [true]);

        var $panel = jQuery('#fhpc_selectDomPanel');
        $panel.html('<p>Click on the desired element</p>');
    }

    function fhpc_itemSelected(el) {
        var $panel = jQuery('#fhpc_selectDomPanel');
        $panel.html('<h3>'+fhpc_adminData.txtElSelected+'</h3>');

        var elementIdentified = getPath(el);
        $panel.append('<p>The desired element is it the one that shines ?</p>');
        $panel.append('<p><a href="javascript:" class="button-primary" data-action="fhpc_confirm" >'+fhpc_adminData.txtYes+'</a>' +
                '<a href="javascript:" class="button-secondary" data-action="fhpc_select" >'+fhpc_adminData.txtNo+'</a></p>');
        $panel.find('[data-action="fhpc_confirm"]').on('click', function () {
            fhpc_confirmElementSelected(elementIdentified);
        });
        $panel.find('[data-action="fhpc_select"]').on('click', fhpc_activeItemSelectionMode);
    }

    function identifyElement(el) {
        var identification = "";
        if (jQuery(el).attr('id')) {
            identification = jQuery(el).attr('id');
        } else {
            identification = getPath(el);
        }
        return identification;
    }

    function getPath(el) {
        var path = '';
        if (jQuery(el).length > 0 && typeof (jQuery(el).prop('tagName')) != "undefined") {
            if (!jQuery(el).attr('id') || jQuery(el).attr('id').substr(0, 9) == 'ultimate-') {
                path = '>' + jQuery(el).prop('tagName') + ':nth-child(' + (jQuery(el).index() + 1) + ')' + path;
                path = getPath(jQuery(el).parent()) + path;
            } else {
                path += '#' + jQuery(el).attr('id');
            }
        }
        return path;
    }

    function fhpc_selectionPanelText() {
        var $panel = jQuery('#fhpc_selectDomPanel');
        $panel.html('<h3>'+fhpc_adminData.txtSelectElement+'</h3>');
        $panel.append('<p>'+fhpc_adminData.txtSelectDetail+'</p>');
        $panel.append('<p><a href="javascript:" class="button-primary">'+fhpc_adminData.txtDefineTarget+'</a></p>');
        $panel.find('a.button-primary').on('click', fhpc_activeItemSelectionMode);
    }
    function fhpc_confirmElementSelected(path) {
        var page = jQuery('#fhpc_selectDomFrame').get(0).contentWindow.document.location.href;
        if (page.substr(page.length - 2, 2) == '//') {
            page = page.substr(0, page.length - 1);
        }
        jQuery('input[name=page]').val(page);
        jQuery('#domElement').val(path);
        jQuery('#domElement').parent().children('span').html(fhpc_adminData.txtElSelected);
        jQuery('#fhpc_selectDomFrame,#fhpc_selectDomPanel').remove();
    }
    function fhpc_saveSettings(e) {

        var error = false;
        jQuery('#fhpc_colorA').removeClass('fhpc_field-error');
        if (jQuery("#fhpc_colorA").val().length != 7) {
            error = true;
            jQuery('#fhpc_colorA').addClass('fhpc_field-error');
        }
        jQuery('#fhpc_colorB').removeClass('fhpc_field-error');
        if (jQuery("#fhpc_colorB").val().length != 7) {
            error = true;
            jQuery('#fhpc_colorB').addClass('fhpc_field-error');
        }
        if (!error) {
            jQuery("#fhpc_response").hide();
            var data = {action: "fhpc_settings_save"};
            jQuery('#fhpc_form_settings input, #fhpc_form_settings select, #fhpc_form_settings textarea').each(function () {
                if (jQuery(this).attr('name')) {
                    eval('data.' + jQuery(this).attr('name') + ' = jQuery(this).val();');
                }
            });
            jQuery.post(ajaxurl, data, function (response) {
                jQuery("#fhpc_response").html('<div id="message" class="updated"><p><strong>'+fhpc_adminData.txtSettingsSaved+'</strong>.</p></div>');
                setTimeout(function () {
                    document.location.href = 'admin.php?page=fhpc_menu';
                }, 250);
            });
        }
    }
    function fhpc_checkStep() {
        if (jQuery('#fhpc_page').val() == "") {
            var page = jQuery('#fhpc_stepID :selected').data('page');
            jQuery('#fhpc_page').val(page);
        }
        jQuery('#fhpc_onAdmin').val(jQuery('#fhpc_stepID :selected').data('admin'));
    }
    function fhpc_checkType() {
        var type = jQuery('#fhpc_type').val();
        if (type == 'tooltip') {
            jQuery('.fhpc_only_dialog').hide();
            jQuery('.fhpc_only_tooltip').show();
        } else if (type == 'dialog') {
            jQuery('#fhpc_delayStart').val(0);
            jQuery('.fhpc_only_dialog').show();
            jQuery('.fhpc_only_tooltip').hide();
            fhpc_checkBtns();
        } else {
            jQuery('#fhpc_delayStart').val(0);
            jQuery('.fhpc_only_dialog').hide();
            jQuery('.fhpc_only_tooltip').hide();
            jQuery('#fhpc_content_tooltip').parent().parent().show();
            jQuery('#fhpc_overlaySelect').parent().parent().hide();
            jQuery('#fhpc_overlaySelect').val('1');
            jQuery('#fhpc_delay').parent().parent().show();
            jQuery('#fhpc_actionNeeded').parent().parent().hide();
            jQuery('#fhpc_actionNeeded').val('delay');
        }
    }
    function fhpc_checkBtns() {
        if ((jQuery('#fhpc_type').val() == 'dialog') && (jQuery('#fhpc_btnContinue').val().length > 0 || jQuery('#btnStop').val().length > 0)) {
            jQuery('#fhpc_actionNeeded').val('click');
            jQuery('#fhpc_actionNeeded').parent().parent().hide();
            jQuery('#fhpc_delay').parent().parent().hide();
        } else if (jQuery('#fhpc_type').val() == 'dialog') {
            jQuery('#fhpc_actionNeeded').val('delay');
            jQuery('#fhpc_delay').parent().parent().show();
        }
    }
    function fhpc_checkAction() {
        if (jQuery('#fhpc_actionNeeded').val() == 'click' && jQuery('#fhpc_type').val() != "text") {
            jQuery('#fhpc_delay').parent().parent().hide();
        } else {
            jQuery('#fhpc_delay').parent().parent().show();
        }
    }
    function fhpc_checkOverlay() {
        if (jQuery('#fhpc_overlaySelect').val() == '1') {
            jQuery('#closeHelperBtn').parent().parent().show();
        } else {
            jQuery('#closeHelperBtn').parent().parent().hide();
        }
    }
    function fhpc_saveItem() {

        var error = false;

        jQuery('#fhpc_domElement').prev().prev('span').css({
            color: '#000'
        });
        jQuery('#fhpc_domElement').removeClass('fhpc_field-error');
        jQuery('#fhpc_title').removeClass('fhpc_field-error');
        if (jQuery("#fhpc_title").val().length < 3) {
            error = true;
            jQuery('#fhpc_title').addClass('fhpc_field-error');
        }
        if (jQuery('#fhpc_type').val() == 'tooltip' && jQuery('#fhpc_domElement').val() && jQuery('#fhpc_domElement').val().length < 2) {
            error = true;
            jQuery('#fhpc_domElement').prev().prev('span').css({
                color: 'red'
            });
            jQuery('#fhpc_domElement').addClass('fhpc_field-error');
        }

        if (!error) {
            jQuery("#fhpc_response").hide();
            var data = {action: "fhpc_item_save"};
            jQuery('#fhpc_form_item input, #fhpc_form_item select, #fhpc_form_item textarea').each(function () {
                if (jQuery(this).attr('name')) {
                    if (jQuery(this).attr('name') != "fhpc_content_tooltip" && jQuery(this).attr('name') != 'onAdmin' && jQuery(this).attr('name') != 'shortcode-filter') {
                        eval('data.' + jQuery(this).attr('name') + ' = jQuery(this).val();');
                    }
                }
            });
            var editor = tinyMCE.get('content');
            if (editor) {
                data.content = editor.getContent();
            } else {
                data.content = jQuery('#content').val();
            }
            if (jQuery('#fhpc_type').val() != 'dialog') {
                data.content = jQuery('#fhpc_content_tooltip').val();
            }

            jQuery.post(ajaxurl, data, function (response) {
                jQuery("#fhpc_response").html('<div id="message" class="updated"><p><strong>'+fhpc_adminData.txtStepSaved+'</strong>.</p></div>');
                jQuery("#fhpc_response").fadeIn(250);
                jQuery('#id').val(response);
                document.location.href = '#wpwrap';
            });
        }
    }
    function fhpc_saveStep() {
        var error = false;
        jQuery('#fhpc_title').removeClass('fhpc_field-error');
        if (jQuery("#fhpc_title").val().length < 3) {
            error = true;
            jQuery('#fhpc_title').addClass('fhpc_field-error');
        }
        if (!error) {
            jQuery("#fhpc_response").hide();
            var data = {action: "fhpc_step_save"};
            jQuery('#fhpc_form_step input, #fhpc_form_step select').each(function () {
                if (jQuery(this).attr('name') && jQuery(this).attr('name') != 'rolesAllowed') {
                    eval('data.' + jQuery(this).attr('name') + ' = jQuery(this).val();');
                }
            });

            var rolesAllowed = '';
            jQuery('input[name=rolesAllowed]:checked').each(function () {
                rolesAllowed += jQuery(this).val() + ',';
            });
            if (rolesAllowed.length > 0) {
                rolesAllowed = rolesAllowed.substr(0, rolesAllowed.length - 1);
            }
            data.rolesAllowed = rolesAllowed;

            if (jQuery('#fhpc_id').val() > 0) {
                eval('localStorage.removeItem(' + jQuery('#fhpc_id').val() + ');');
            }

            jQuery.post(ajaxurl, data, function (response) {
                jQuery("#fhpc_response").html('<div id="message" class="updated"><p><strong>'+fhpc_adminData.txtStepSaved+'</strong>.</p></div>');
                jQuery("#fhpc_response").fadeIn(250);
                jQuery('#fhpc_id').val(response);
                document.location.href = '#wpwrap';
            });

        }
    }
    function fhpc_changeOnAdmin() {
        if (jQuery('#fhpc_onAdmin').val() == '1') {
            jQuery('#fhpc_form_step #fhpc_page').val(document.location.href.substr(0, document.location.href.lastIndexOf('/')));
        } else {
            jQuery('#fhpc_form_step #fhpc_page').val('');
        }
    }
    function fhpc_checkStart() {
        if (jQuery('#fhpc_start').val() == 'click') {
            jQuery('#fhpc_domElement').parent().parent().show();
            jQuery('#fhpc_onceTime').parent().parent().hide();
        } else {
            jQuery('#fhpc_domElement').parent().parent().hide();
            jQuery('#fhpc_onceTime').parent().parent().show();
        }
    }
    function fhpc_mobileEnabledChanged() {
        if (jQuery('#fhpc_mobileEnabled').val() == 1) {
            jQuery('#fhpc_onlyMobile').closest('tr').slideDown();
        } else {
            jQuery('#fhpc_onlyMobile').val(0);
            jQuery('#fhpc_onlyMobile').closest('tr').slideUp();
        }
    }
})(jQuery);